<?php
/**
 * Elementor Widget
 * @package Bizmaster
 * @since 1.0.0
 */

namespace Elementor;
class Bizmaster_Career_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'bizmaster-career-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Career', 'bizmaster-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-editor-list-ul';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['bizmaster_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
		$this->start_controls_section(
			'settings_section',
			[
				'label' => esc_html__('General Settings', 'bizmaster-core'),
				'tab' => Controls_Manager::TAB_CONTENT
			]
		);

        $repeater = new \Elementor\Repeater();

		$repeater->add_control(
            'career-image', [
                'label' => esc_html__('Main Image', 'bizmaster-core'),
                'type' => Controls_Manager::MEDIA,
				'default'	=> array( 'url' => Utils::get_placeholder_image_src() ),
                'show_label' => false,
                'description' => esc_html__('Upload Main image', 'bizmaster-core'),
            ]
        );

		$repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Networ Infra Tructure Solutions', 'bizmaster-core'),
                'show_label' => true,
                'description' => esc_html__('type title', 'bizmaster-core'),
            ]
        );

        $repeater->add_control(
			'content', [
				'label' => esc_html__('Content', 'bizmaster-core'),
				'type' => Controls_Manager::TEXTAREA,
				'description' => esc_html__('enter content.', 'bizmaster-core'),
				'default' => esc_html__('IT Technology is a category a encompassing.', 'bizmaster-core')
			]
		);

		$this->add_control('career_items', [
            'label' => esc_html__('Career Items', 'bizmaster-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
        ]);

		$this->end_controls_section();

        /*  tab styling tabs start */
		$this->start_controls_section(
			'style_settings_section',
			[
				'label' => esc_html__('Style Settings', 'bizmaster-core'),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_control('career_card_background', [
            'label' => esc_html__('Career Card BG', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .wcu-card" => "background: {{VALUE}}"
            ]
        ]);

		$this->add_responsive_control(
			'career_card_padding',
			[
				'label'      => esc_html__('Padding', 'bizmaster-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .wcu-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'career_card_icon_margin',
			[
				'label'      => esc_html__('Career Card Icon Margin', 'bizmaster-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .wcu-card .icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control('career_card_icon_background', [
            'label' => esc_html__('Career Card Icon BG', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .wcu-card .icon" => "background: {{VALUE}}"
            ]
        ]);

		$this->add_control('career_card_title_color', [
            'label' => esc_html__('Title Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .wcu-card .wcu-card-details .wcu-card-title" => "color: {{VALUE}}"
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Title Typography', 'bizmaster-core'),
			'name' => 'career_card_title_typography',
			'description' => esc_html__('Title Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .wcu-card .wcu-card-details .wcu-card-title"
		]);

		$this->add_control('career_card_content_color', [
            'label' => esc_html__('Content Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .wcu-card .wcu-card-details .wcu-card-text" => "color: {{VALUE}}"
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Content Typography', 'bizmaster-core'),
			'name' => 'career_card_content_typography',
			'description' => esc_html__('Content Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .wcu-card .wcu-card-details .wcu-card-text"
		]);

		$this->end_controls_section();
	}

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$career_items = $settings['career_items'];
		?>
		<div class="wcu-card-wrap">
			<?php foreach ($career_items as $item): ?>
			<div class="wcu-card">
				<div class="icon">
					<?php if (!empty($item['career-image'])) : ?>
						<img src="<?php echo $item['career-image']['url']; ?>" alt="<?php echo $item['title']; ?>">
                    <?php endif; ?>
                </div>
				<div class="wcu-card-details">
					<h4 class="wcu-card-title"><?php echo $item['title']; ?></h4>
					<p class="wcu-card-text"><?php echo $item['content']; ?></p>
				</div>
			</div>
			<?php endforeach; ?>
		</div>
		<?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type(new Bizmaster_Career_Widget());
