<?php
/**
 * Theme Custom Post Type(CPTs)
 * @package Bizmaster
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}

if (!class_exists('Bizmaster_Custom_Post_Type')) {
    class Bizmaster_Custom_Post_Type
    {

        //$instance variable
        private static $instance;

        public function __construct()
        {
            //register post type
            add_action('init', array($this, 'register_custom_post_type'));
        }

        /**
         * get Instance
         * @since  2.0.0
         */
        public static function getInstance()
        {
            if (null == self::$instance) {
                self::$instance = new self();
            }

            return self::$instance;
        }

        /**
         * Register Custom Post Type
         * @since  2.0.0
         */
        public function register_custom_post_type()
        {
            if (!defined('ELEMENTOR_VERSION')) {
                return;
            }
            $all_post_type = array(
                [
                    'post_type' => 'service',
                    'args' => array(
                        'label' => esc_html__('Service', 'bizmaster-core'),
                        'description' => esc_html__('Service', 'bizmaster-core'),
                        'labels' => array(
                            'name' => esc_html_x('Service', 'Post Type General Name', 'bizmaster-core'),
                            'singular_name' => esc_html_x('Service', 'Post Type Singular Name', 'bizmaster-core'),
                            'menu_name' => esc_html__('Services', 'bizmaster-core'),
                            'all_items' => esc_html__('Services', 'bizmaster-core'),
                            'view_item' => esc_html__('View Services', 'bizmaster-core'),
                            'add_new_item' => esc_html__('Add New Service', 'bizmaster-core'),
                            'add_new' => esc_html__('Add New Service', 'bizmaster-core'),
                            'edit_item' => esc_html__('Edit Service', 'bizmaster-core'),
                            'update_item' => esc_html__('Update Service', 'bizmaster-core'),
                            'search_items' => esc_html__('Search Service', 'bizmaster-core'),
                            'not_found' => esc_html__('Not Found', 'bizmaster-core'),
                            'not_found_in_trash' => esc_html__('Not found in Trash', 'bizmaster-core'),
                            'featured_image' => esc_html__('Service Image', 'bizmaster-core'),
                            'remove_featured_image' => esc_html__('Remove Service Image', 'bizmaster-core'),
                            'set_featured_image' => esc_html__('Set Service Image', 'bizmaster-core'),
                        ),
                        'supports' => array('title', 'thumbnail', 'excerpt', 'editor', 'comments'),
                        'hierarchical' => true,
                        'public' => true,
                        "publicly_queryable" => true,
                        'show_ui' => true,
                        'show_in_menu' => true,
                        "rewrite" => array('slug' => 'service', 
                        'with_front' => true),
                        'can_export' => true,
                        'capability_type' => 'post',
                        "show_in_rest" => true,
                        'query_var' => true,
                    )
                ],
                [
                    'post_type' => 'project',
                    'args' => array(
                        'label' => esc_html__('Project', 'bizmaster-core'),
                        'description' => esc_html__('Project', 'bizmaster-core'),
                        'labels' => array(
                            'name' => esc_html_x('Project', 'Post Type General Name', 'bizmaster-core'),
                            'singular_name' => esc_html_x('Project', 'Post Type Singular Name', 'bizmaster-core'),
                            'menu_name' => esc_html__('Projects', 'bizmaster-core'),
                            'all_items' => esc_html__('Projects', 'bizmaster-core'),
                            'view_item' => esc_html__('View Projects', 'bizmaster-core'),
                            'add_new_item' => esc_html__('Add New Project', 'bizmaster-core'),
                            'add_new' => esc_html__('Add New Project', 'bizmaster-core'),
                            'edit_item' => esc_html__('Edit Project', 'bizmaster-core'),
                            'update_item' => esc_html__('Update Project', 'bizmaster-core'),
                            'search_items' => esc_html__('Search Project', 'bizmaster-core'),
                            'not_found' => esc_html__('Not Found', 'bizmaster-core'),
                            'not_found_in_trash' => esc_html__('Not found in Trash', 'bizmaster-core'),
                            'featured_image' => esc_html__('Project Image', 'bizmaster-core'),
                            'remove_featured_image' => esc_html__('Remove Project Image', 'bizmaster-core'),
                            'set_featured_image' => esc_html__('Set Project Image', 'bizmaster-core'),
                        ),
                        'supports' => array('title', 'thumbnail', 'excerpt', 'editor', 'comments'),
                        'hierarchical' => false,
                        'public' => true,
                        "publicly_queryable" => true,
                        'show_ui' => true,
                        'show_in_menu' => true,
                        "rewrite" => array('slug' => 'project', 'with_front' => true),
                        'can_export' => true,
                        'capability_type' => 'post',
                        "show_in_rest" => true,
                        'query_var' => true
                    )
                ],
                [
                    'post_type' => 'team',
                    'args' => array(
                        'label' => esc_html__('team', 'bizmaster-core'),
                        'description' => esc_html__('team', 'bizmaster-core'),
                        'labels' => array(
                            'name' => esc_html_x('Team', 'Post Type General Name', 'bizmaster-core'),
                            'singular_name' => esc_html_x('Team', 'Post Type Singular Name', 'bizmaster-core'),
                            'menu_name' => esc_html__('Teams', 'bizmaster-core'),
                            'all_items' => esc_html__('Teams', 'bizmaster-core'),
                            'view_item' => esc_html__('View Teams', 'bizmaster-core'),
                            'add_new_item' => esc_html__('Add New Team Member', 'bizmaster-core'),
                            'add_new' => esc_html__('Add New Team Member', 'bizmaster-core'),
                            'edit_item' => esc_html__('Edit Team', 'bizmaster-core'),
                            'update_item' => esc_html__('Update Team', 'bizmaster-core'),
                            'search_items' => esc_html__('Search Team', 'bizmaster-core'),
                            'not_found' => esc_html__('Not Found', 'bizmaster-core'),
                            'not_found_in_trash' => esc_html__('Not found in Trash', 'bizmaster-core'),
                            'featured_image' => esc_html__('Team Image', 'bizmaster-core'),
                            'remove_featured_image' => esc_html__('Remove Team Image', 'bizmaster-core'),
                            'set_featured_image' => esc_html__('Set Team Image', 'bizmaster-core'),
                        ),
                        'supports' => array('title', 'thumbnail', 'excerpt', 'editor', 'comments'),
                        'hierarchical' => false,
                        'public' => true,
                        "publicly_queryable" => true,
                        'show_ui' => true,
                        'show_in_menu' => true,
                        "rewrite" => array('slug' => 'team', 'with_front' => true),
                        'can_export' => true,
                        'capability_type' => 'post',
                        "show_in_rest" => true,
                        'query_var' => true
                    )
                ]
            );

            if (!empty($all_post_type) && is_array($all_post_type)) {

                foreach ($all_post_type as $post_type) {
                    call_user_func_array('register_post_type', $post_type);
                }
            }


            /**
             * Custom Taxonomy Register
             * @since 1.0.0
             */

            $all_custom_taxonmy = array(
                array(
                    'taxonomy' => 'service-category',
                    'object_type' => 'service',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Service Category", 'bizmaster-core'),
                            "singular_name" => esc_html__("Service Category", 'bizmaster-core'),
                            "menu_name" => esc_html__("Service Category", 'bizmaster-core'),
                            "all_items" => esc_html__("All Service Category", 'bizmaster-core'),
                            "add_new_item" => esc_html__("Add New Service Category", 'bizmaster-core')
                        ),
                        "public" => true,
                        "hierarchical" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'service-category', 'with_front' => true),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                    )
                ),
                array(
                    'taxonomy' => 'project-category',
                    'object_type' => 'project',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Project Category", 'bizmaster-core'),
                            "singular_name" => esc_html__("Project Category", 'bizmaster-core'),
                            "menu_name" => esc_html__("Project Category", 'bizmaster-core'),
                            "all_items" => esc_html__("All Project Category", 'bizmaster-core'),
                            "add_new_item" => esc_html__("Add New Project Category", 'bizmaster-core')
                        ),
                        "public" => true,
                        "hierarchical" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'project-category', 'with_front' => true),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                    )
                ),
                array(
                    'taxonomy' => 'team-category',
                    'object_type' => 'team',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Team Category", 'bizmaster-core'),
                            "singular_name" => esc_html__("Team Category", 'bizmaster-core'),
                            "menu_name" => esc_html__("Team Category", 'bizmaster-core'),
                            "all_items" => esc_html__("All Team Category", 'bizmaster-core'),
                            "add_new_item" => esc_html__("Add New Team Category", 'bizmaster-core')
                        ),
                        "public" => true,
                        "hierarchical" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'team-category', 'with_front' => true),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                    )
                )
            );

            if (is_array($all_custom_taxonmy) && !empty($all_custom_taxonmy)) {
                foreach ($all_custom_taxonmy as $taxonomy) {
                    call_user_func_array('register_taxonomy', $taxonomy);
                }
            }


            /**
             * Custom Tags Register
             * @since 1.0.0
             */

            $all_custom_tags = array(
                array(
                    'taxonomy' => 'service-tag',
                    'object_type' => 'service',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Service Tag", 'bizmaster-core'),
                            "singular_name" => esc_html__("Service Tag", 'bizmaster-core'),
                            "menu_name" => esc_html__("Service Tag", 'bizmaster-core'),
                            "all_items" => esc_html__("All Service Tag", 'bizmaster-core'),
                            "add_new_item" => esc_html__("Add New Service Tag", 'bizmaster-core')
                        ),
                        "public" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'service-tag'),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                        'hierarchical' => false,
                        'update_count_callback' => '_update_post_term_count',
                    )
                ),
                array(
                    'taxonomy' => 'project-tag',
                    'object_type' => 'project',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Project Tag", 'bizmaster-core'),
                            "singular_name" => esc_html__("Project Tag", 'bizmaster-core'),
                            "menu_name" => esc_html__("Project Tag", 'bizmaster-core'),
                            "all_items" => esc_html__("All Project Tag", 'bizmaster-core'),
                            "add_new_item" => esc_html__("Add New Project Tag", 'bizmaster-core')
                        ),
                        "public" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'project-tag'),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                        'hierarchical' => false,
                        'update_count_callback' => '_update_post_term_count',
                    )
                ),
                array(
                    'taxonomy' => 'team-tag',
                    'object_type' => 'team',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Team Tag", 'bizmaster-core'),
                            "singular_name" => esc_html__("Team Tag", 'bizmaster-core'),
                            "menu_name" => esc_html__("Team Tag", 'bizmaster-core'),
                            "all_items" => esc_html__("All Team Tag", 'bizmaster-core'),
                            "add_new_item" => esc_html__("Add New Team Tag", 'bizmaster-core')
                        ),
                        "public" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'team-tag'),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                        'hierarchical' => false,
                        'update_count_callback' => '_update_post_term_count',
                    )
                ),
            );

            if (is_array($all_custom_tags) && !empty($all_custom_tags)) {
                foreach ($all_custom_tags as $tags) {
                    call_user_func_array('register_taxonomy', $tags);
                }
            }


            flush_rewrite_rules();
        }

    }//end class

    if (class_exists('Bizmaster_Custom_Post_Type')) {
        Bizmaster_Custom_Post_Type::getInstance();
    }
}